/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.api.geometry;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.runelite.api.geometry.Shapes;
import net.runelite.api.geometry.SimplePolygon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RectangleUnion {
    private static final Logger log = LoggerFactory.getLogger(RectangleUnion.class);

    private RectangleUnion() {
    }

    @Nullable
    public static Shapes<SimplePolygon> union(List<Rectangle> lefts) {
        if (lefts.size() == 0) {
            return null;
        }
        boolean trace = log.isTraceEnabled();
        lefts.sort(Comparator.comparingInt(Rectangle::getX1));
        ArrayList<Rectangle> rights = new ArrayList<Rectangle>(lefts);
        rights.sort(Comparator.comparingInt(Rectangle::getX2));
        Segments segments = new Segments();
        Shapes<SimplePolygon> out = new Shapes<SimplePolygon>(new ArrayList());
        ChangingState cs2 = new ChangingState(out);
        int l2 = 0;
        int r2 = 0;
        while (true) {
            Rectangle rect;
            boolean remove;
            Rectangle lr = null;
            Rectangle rr = null;
            if (l2 < lefts.size()) {
                lr = lefts.get(l2);
            }
            if (r2 < rights.size()) {
                rr = (Rectangle)rights.get(r2);
            }
            if (lr == null && rr == null) break;
            boolean bl2 = remove = lr == null || rr != null && rr.x2 < lr.x1;
            if (remove) {
                cs2.delta = -1;
                cs2.x = rr.x2;
                ++r2;
                rect = rr;
            } else {
                cs2.delta = 1;
                cs2.x = lr.x1;
                ++l2;
                rect = lr;
            }
            if (trace) {
                log.trace("{}{}", (Object)(remove ? "-" : "+"), (Object)rect);
            }
            int y1 = rect.y1;
            int y2 = rect.y2;
            Segment n2 = segments.findLE(y1);
            if (n2 == null) {
                n2 = segments.insertAfter(null, y1);
            }
            if (n2.y != y1) {
                n2 = segments.insertAfter(n2, y1);
                n2.value = n2.previous.value;
            }
            do {
                if (n2.next == null || n2.next.y > y2) {
                    segments.insertAfter(n2, y2);
                }
                cs2.touch(n2);
                n2 = n2.next;
            } while (n2.y != y2);
            cs2.finish(n2);
            if (!trace) continue;
            Segment s2 = segments.first;
            while (s2 != null) {
                Object chunk = "";
                if (s2.chunk != null) {
                    chunk = (s2.left ? ">" : "[") + System.identityHashCode(s2.chunk) + (s2.left ? "]" : "<");
                }
                log.trace("{} = {} {}", s2.y, s2.value, chunk);
                s2 = s2.next;
            }
            log.trace("");
        }
        assert (segments.allZero());
        return out;
    }

    private static class Chunk
    extends SimplePolygon {
        Segment left;
        Segment right;

        private Chunk() {
        }

        @Override
        public void reverse() {
            super.reverse();
            assert (!this.right.left);
            assert (this.left.left);
            Segment tr = this.left;
            this.left = this.right;
            this.right = tr;
            this.right.left = false;
            this.left.left = true;
        }
    }

    private static class Segments {
        Segment first;

        Segment findLE(int y2) {
            Segment s2 = this.first;
            if (s2 == null || s2.y > y2) {
                return null;
            }
            while (s2.y != y2) {
                Segment n2 = s2.next;
                if (n2 == null || n2.y > y2) {
                    return s2;
                }
                s2 = n2;
            }
            return s2;
        }

        Segment insertAfter(Segment before, int y2) {
            Segment n2 = new Segment();
            n2.y = y2;
            if (before != null) {
                if (before.next != null) {
                    n2.next = before.next;
                    n2.next.previous = n2;
                }
                n2.value = before.value;
                before.next = n2;
                n2.previous = before;
            } else {
                if (this.first != null) {
                    n2.next = this.first;
                    this.first.previous = n2;
                }
                this.first = n2;
            }
            return n2;
        }

        boolean allZero() {
            Segment s2 = this.first;
            while (s2 != null) {
                if (s2.value != 0 || s2.chunk != null) {
                    return false;
                }
                s2 = s2.next;
            }
            return true;
        }
    }

    private static class Segment {
        Segment next;
        Segment previous;
        Chunk chunk;
        boolean left;
        int y;
        int value;
    }

    private static class ChangingState {
        final Shapes<SimplePolygon> out;
        int x;
        int delta;
        Segment first;

        void touch(Segment s2) {
            int oldValue = s2.value;
            s2.value += this.delta;
            if (oldValue <= 0 ^ s2.value <= 0) {
                if (this.first == null) {
                    this.first = s2;
                }
            } else {
                this.finish(s2);
            }
        }

        void finish(Segment s2) {
            if (this.first == null) {
                return;
            }
            if (this.first.chunk != null && s2.chunk != null) {
                this.push(this.first);
                this.push(s2);
                if (this.first.chunk == s2.chunk) {
                    Chunk c2 = this.first.chunk;
                    this.first.chunk = null;
                    s2.chunk = null;
                    c2.left = null;
                    c2.right = null;
                    this.out.getShapes().add(c2);
                } else {
                    Chunk rightChunk;
                    Chunk leftChunk;
                    if (!s2.left) {
                        leftChunk = s2.chunk;
                        rightChunk = this.first.chunk;
                    } else {
                        leftChunk = this.first.chunk;
                        rightChunk = s2.chunk;
                    }
                    log.trace("Joining {} onto {}", (Object)System.identityHashCode(rightChunk), (Object)System.identityHashCode(leftChunk));
                    if (this.first.left == s2.left) {
                        log.trace("reverse");
                        if (this.first.left) {
                            leftChunk.reverse();
                        } else {
                            rightChunk.reverse();
                        }
                    }
                    log.trace("{} {}", (Object)this.first.y, (Object)s2.y);
                    rightChunk.appendTo(leftChunk);
                    this.first.chunk = null;
                    s2.chunk = null;
                    leftChunk.right.chunk = null;
                    rightChunk.left.chunk = null;
                    leftChunk.right = rightChunk.right;
                    leftChunk.left.chunk = leftChunk;
                    leftChunk.right.chunk = leftChunk;
                }
            } else if (this.first.chunk == null && s2.chunk == null) {
                this.first.chunk = new Chunk();
                this.first.chunk.right = this.first;
                this.first.left = false;
                s2.chunk = this.first.chunk;
                this.first.chunk.left = s2;
                s2.left = true;
                this.push(this.first);
                this.push(s2);
            } else if (this.first.chunk == null) {
                this.push(s2);
                this.move(this.first, s2);
                this.push(this.first);
            } else {
                this.push(this.first);
                this.move(s2, this.first);
                this.push(s2);
            }
            this.first = null;
        }

        private void move(Segment dst, Segment src) {
            dst.chunk = src.chunk;
            dst.left = src.left;
            src.chunk = null;
            if (dst.left) {
                assert (dst.chunk.left == src);
                dst.chunk.left = dst;
            } else {
                assert (dst.chunk.right == src);
                dst.chunk.right = dst;
            }
        }

        private void push(Segment s2) {
            if (s2.left) {
                s2.chunk.pushLeft(this.x, s2.y);
                assert (s2.chunk.left == s2);
            } else {
                s2.chunk.pushRight(this.x, s2.y);
                assert (s2.chunk.right == s2);
            }
        }

        public ChangingState(Shapes<SimplePolygon> out) {
            this.out = out;
        }
    }

    public static class Rectangle {
        private final int x1;
        private final int y1;
        private final int x2;
        private final int y2;

        public Rectangle(int x1, int y1, int x2, int y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        public int getX1() {
            return this.x1;
        }

        public int getY1() {
            return this.y1;
        }

        public int getX2() {
            return this.x2;
        }

        public int getY2() {
            return this.y2;
        }

        public String toString() {
            return "RectangleUnion.Rectangle(x1=" + this.getX1() + ", y1=" + this.getY1() + ", x2=" + this.getX2() + ", y2=" + this.getY2() + ")";
        }
    }
}

